#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));

const int N = 40500;

double X[N], Y[N];

double ang(int a, int b, int c)
{
	double vx = X[b] - X[a], vy = Y[b] - Y[a];
	double ux = X[c] - X[b], uy = Y[c] - Y[b];
	double v = atan2(vx * uy - ux * vy, vx * ux + vy * uy);
	return fabs(v);
}

bool sp[N];

struct route
{
	int T[2][2];
	int x;
	double val()
	{
		if (sp[x])
			return ang(T[0][0], x, T[0][1]) + ang(T[1][0], x, T[1][1]);
		else
			return ang(T[0][0], x, T[0][1]);
	}
	friend bool operator <(route a, route b)
	{
		assert(sp[a.x] && sp[b.x]);
		assert(a.x == b.x);
		return a.val() < b.val();
	}
	int travel(int z)
	{
		if (sp[x])
		{
			for (int t = 0; t < 2; t++)
				if (T[t][0] == z || T[t][1] == z)
					return T[t][0] ^ T[t][1] ^ z;
			assert(false);
			return -1;
		}
		else
		{
			assert(T[0][0] == z || T[0][1] == z);
			return T[0][0] ^ T[0][1] ^ z;
		}
	}
} R[N][3];

vector<int> E[N];


int cpt = 0;
map<pair<int, int>, int> color;

void go(int x, int y, int c)
{
	eprintf("color = %d\n", c);
	while (true)
	{
		if (color.find(make_pair(x, y)) != color.end())
			break;
		color[make_pair(x, y)] = color[make_pair(y, x)] = c;
		int z = R[y][0].travel(x);
		x = y;
		y = z;
		eprintf("%d ", z);
	}
	eprintf("\n");
}

map<pair<int, int>, double> cost;

pair<double, pair<int, int> > edges[N];

int par[N];
int rnk[N];

int get(int x)
{
	return (x == par[x]) ? x : (par[x] = get(par[x]));
}

void merge(int a, int b)
{
	a = get(a);
	b = get(b);
	if (a == b)
		return;
	if (rnk[a] > rnk[b])
		swap(a, b);
	if (rnk[a] == rnk[b])
		rnk[b]++;
	par[a] = b;
}

int main() {
#ifdef LOCAL42
#define TASK "K"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int n, m;
	scanf("%d %d", &n, &m);
	for (int i = 0; i < n; i++)
		scanf("%lf %lf", &X[i], &Y[i]);
	
	for (int i = 0; i < m; i++)
	{
		int a, b;
		scanf("%d %d", &a, &b);
		E[a].push_back(b);
		E[b].push_back(a);
	}
	double ans = 0;
	for (int i = 0; i < n; i++)
	{
		if (E[i].size() == 4)
		{
			sp[i] = true;
			for (int j = 1; j < 4; j++)
			{
				R[i][j - 1].x = i;
				R[i][j - 1].T[0][0] = E[i][0];
				R[i][j - 1].T[0][1] = E[i][j];
				R[i][j - 1].T[1][0] = E[i][1 + (j - 1 + 1) % 3];
				R[i][j - 1].T[1][1] = E[i][1 + (j - 1 + 2) % 3];
			}
			sort(R[i], R[i] + 3);
		}
		else
		{
			R[i][0].x = i;
			R[i][0].T[0][0] = E[i][0];
			R[i][0].T[0][1] = E[i][1];
		}
		ans += R[i][0].val();
	}

	for (int i = 0; i < n; i++)
	{
		for (int t = 0; t < (sp[i] ? 2 : 1); t++)
			if (color.find(make_pair(R[i][0].T[t][0], i)) == color.end())
				go(R[i][0].T[t][0], i, cpt++);
	}

	for (int i = 0; i < n; i++)
	{
		if (sp[i])
		{
			assert(color.find(make_pair(i, R[i][0].T[0][0])) != color.end());
			assert(color.find(make_pair(i, R[i][0].T[1][0])) != color.end());

			int c0 = color[make_pair(i, R[i][0].T[0][0])];
			int c1 = color[make_pair(i, R[i][0].T[1][0])];
			if (c1 < c0)
				swap(c1, c0);
			if (c0 == c1)
			{
				eprintf("in %d same %d", i, c1);
				continue;
			}
			else
			{
				eprintf("in %d -> %d and %d\n", i, c0, c1);
				double q = R[i][1].val();
				double al = R[i][0].val();
				assert(q > al - eps);
				if (cost.find(make_pair(c0, c1)) == cost.end())
					cost[make_pair(c0, c1)] = q - al;
				else
					cost[make_pair(c0, c1)] = min(cost[make_pair(c0, c1)], q - al);
			}
		}
	}

	int ept = 0;

	for (map<pair<int, int>, double>::iterator it = cost.begin(); it != cost.end(); it++)
		edges[ept++] = make_pair(it->second, it->first);

	sort(edges, edges + ept);

	for (int i = 0; i < cpt; i++)
		par[i] = i;

	int cnt = 0;

	for (int i = 0; i < ept; i++)
	{
		int a = edges[i].second.first;
		int b = edges[i].second.second;
		a = get(a);
		b = get(b);
		if (a == b)
			continue;
		else
		{
			merge(a, b);
			ans += edges[i].first;
			cnt++;
		}
	}
	assert(cnt + 1 == cpt);
	printf("%.10lf\n", ans);
		
	return 0;
}
